package com.ejie.ab04b.service;

import java.util.List;

import com.ejie.ab04b.model.CnaeJ73;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * CnaeJ73Service generated by UDA, 27-jul-2016 11:29:27.
 * 
 * @author UDA
 */

public interface CnaeJ73Service {

	/**
	 * Finds a single row in the CnaeJ73 table.
	 * 
	 *  cnaej73
	 *            CnaeJ73
	 *  CnaeJ73
	 *
	 * @param cnaej73 the cnaej 73
	 * @return the cnae J 73
	 */
	CnaeJ73 find(CnaeJ73 cnaej73);

	/**
	 * Finds a list of rows in the CnaeJ73 table.
	 * 
	 *  cnaej73
	 *            CnaeJ73
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<CnaeJ73>
	 *
	 * @param cnaej73 the cnaej 73
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<CnaeJ73> findAll(CnaeJ73 cnaej73, JQGridRequestDto jqGridRequestDto);

	/**
	 * Obtiene las cnaej73 principales (de primer nivel).
	 * 
	 *  cnaej73            Vcnaej73
	 *  List<Vcnaej73>
	 *
	 * @param cnaej73 the cnaej 73
	 * @return the list
	 */
	public List<CnaeJ73> findAllNivelSuperior(CnaeJ73 cnaej73);

	/**
	 * Obtiene las cnaej73 de una seccion.
	 * 
	 *  cnaej73            Vcnaej73
	 *  List<Vcnaej73>
	 *
	 * @param cnaej73 the cnaej 73
	 * @return the list
	 */
	public List<CnaeJ73> findAllBySeccion(CnaeJ73 cnaej73);

	/**
	 * Obtiene las cnaej73 de una seccion.
	 * 
	 *  cnaej73            Vcnaej73
	 *  List<Vcnaej73>
	 *
	 * @param cnaej73 the cnaej 73
	 * @return the cnae J 73
	 */
	public CnaeJ73 findByCnae(CnaeJ73 cnaej73);

	/**
	 * Finds rows in the CnaeJ73 table using like.
	 * 
	 *  cnaej73
	 *            CnaeJ73
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<CnaeJ73>
	 *
	 * @param cnaej73 the cnaej 73
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<CnaeJ73> findAllLike(CnaeJ73 cnaej73, JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Finds rows in the CnaeJ73 table using like.
	 * 
	 *  cnaej73
	 *            CnaeJ73
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<CnaeJ73>
	 *
	 * @param cnaej73 the cnaej 73
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<CnaeJ73> findAllForAutocomplete(CnaeJ73 cnaej73, JQGridRequestDto jqGridRequestDto, Boolean startsWith);

}
